﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace LINQ_over_DataSet
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'telefonyDataSet.ListaOsob' table. You can move, or remove it, as needed.
            this.listaOsobTableAdapter.Fill(this.telefonyDataSet.ListaOsob);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in telefonyDataSet.ListaOsob where osoba.Wiek >= 18 orderby osoba.Nazwisko, osoba.Imię select new Osoba { Id = osoba.Id, Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, NumerTelefonu = osoba.NumerTelefonu, Wiek = osoba.Wiek };
            
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
                                    
            DataTable dt = new DataTable("ListaOsobPelnoletnich");

            Osoba first = listaOsobPelnoletnich.First();
            DataColumn dcId=new DataColumn("Id");
            dcId.AllowDBNull=false;
            dcId.DataType = first.Id.GetType();
            DataColumn dcImię = new DataColumn("Imię");
            dcImię.DataType = first.Imię.GetType();
            DataColumn dcNazwisko = new DataColumn("Nazwisko");
            dcNazwisko.DataType = first.Nazwisko.GetType();
            DataColumn dcNumerTelefonu = new DataColumn("NumerTelefonu");
            dcNumerTelefonu.DataType = first.NumerTelefonu.GetType();
            DataColumn dcWiek = new DataColumn("Wiek");
            dcWiek.DataType = first.Wiek.GetType();
            
            dt.Columns.Add(dcId);
            dt.Columns.Add(dcImię);
            dt.Columns.Add(dcNazwisko);
            dt.Columns.Add(dcNumerTelefonu);
            dt.Columns.Add(dcWiek);
             
            foreach(Osoba osoba in listaOsobPelnoletnich)
            {
                DataRow dr=dt.NewRow();
                dr["Id"] = osoba.Id;
                dr["Imię"] = osoba.Imię;
                dr["Nazwisko"] = osoba.Nazwisko;
                dr["NumerTelefonu"] = osoba.NumerTelefonu;
                dr["Wiek"] = osoba.Wiek;
                dt.Rows.Add(dr);
            }
            MessageBox.Show("Ilość rekordów w tabeli: " + dt.Rows.Count.ToString());
            telefonyDataSet.Tables.Add(dt);

            MessageBox.Show("Ilość tabel w telefonyDataSet: " + telefonyDataSet.Tables.Count.ToString());

            telefonyDataSetBindingSource.DataMember = "ListaOsobPelnoletnich";
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //odczytywanie szczegółowych informacji
            DataTable dt=telefonyDataSet.ListaOsob;
            int iloscOsobPelnoletnich = dt.AsEnumerable().Count(dr => dr.Field<int>("Wiek") > 18);
            MessageBox.Show("Ilość osób pełnoletnich: " + iloscOsobPelnoletnich);

            //obliczenia
            double sredniWiek=dt.AsEnumerable().Average(osoba => osoba.Field<int>("Wiek"));
            MessageBox.Show("Średni wiek: " + sredniWiek);

            //dowolność sortowania i filtrowania pobieranych danych
            var listaKobiet = from osoba in telefonyDataSet.ListaOsob where osoba.Imię.EndsWith("a") orderby -osoba.Nazwisko.Length select new Osoba { Id = osoba.Id, Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, NumerTelefonu = osoba.NumerTelefonu, Wiek = osoba.Wiek };

            string s = "Kobiety posortowane względem długości nazwisk:\n";
            foreach (Osoba osoba in listaKobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("ListaOsob",
                    from osoba in telefonyDataSet.ListaOsob
                    orderby osoba.Wiek
                    select new XElement("Osoba",
                        new XAttribute("Id", osoba.Id),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("NumerTelefonu", osoba.NumerTelefonu),
                        new XElement("Wiek", osoba.Wiek)
                    )
                )
            );

            xml.Save("Telefony.xml");
        }
    }

    class Osoba
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;
    }
}
